Since AGiXT is designed to build customizable and extensible AI agents, there are different services to satisfy the goal. In the web UI of AGiXT, you will see the services that include Agent Management, Agent Training, Agent Interactions, Memory Management, Prompt Management, and Chains Management.

## Agent Management
This service is dedicated to managing the agent such as agent settings that you can find more details in [Agents](https://josh-xt.github.io/AGiXT/2-Concepts/3-Agents.html) section. The agent settings part modifies the settings in text generation models based on the available [Providers](https://josh-xt.github.io/AGiXT/2-Concepts/2-Providers.html). Moreover, you can find the file system settings that enable the agent to read through different files or connect to different services such as GitHub, Whisper, Dalle, Discord, etc. Applying these settings to the agent makes the agent more aligned with the user's expectations.

## Agent Training
The agent can train based on the additional resources provided to it. These resources include websites, different file formats, text (i.e., a pair of question and answer that the user provides), and GitHub repositories. You can find more details about these training modes in [Agent Training](https://josh-xt.github.io/AGiXT/2-Concepts/8-Agent%20Training.html) section.

In addition to the fundamental settings for agent training, the user can provide more advanced options such as predefined memory collections that can be used by developers. These options include storing the web search results, positive/negative feedback, etc.

## Agent Interactions
There are different modes to interact with the agent including Chat, Chains, Prompt, and Instruct. You can find more information about each of these modes and how they differ from each other in [Core Concepts](https://josh-xt.github.io/AGiXT/2-Concepts/0-Core%20Concepts.html). Moreover, you can find more details and advanced options for these modes in the [Agent Interactions](https://josh-xt.github.io/AGiXT/2-Concepts/9-Agent%20Interactions.html) section.

## Memory Management
The agent can search for a query based on the memory and the documents it was trained on, in Agent Training. You can find more details in the Memory Management section of [Agent Training](https://josh-xt.github.io/AGiXT/2-Concepts/8-Agent%20Training.html).

Advanced options for memory management include predefined memory collections, number of the output memories, and the minimum relevance score for a memory to be returned.

## Prompt Management
This feature helps in managing the prompts when working with the agents. Prompt management assists in creating, editing, and deleting prompts, or even changing them to conversations. You can learn more about it in [Prompts](https://josh-xt.github.io/AGiXT/2-Concepts/5-Prompts.html) section. There are also more details about the conversations in [Conversations](https://josh-xt.github.io/AGiXT/2-Concepts/7-Conversations.html).

## Chains Management
This service emphasizes the chain feature of the agents. You can learn more about what they are and how you can use predefined variables in AGiXT in [Chains](https://josh-xt.github.io/AGiXT/2-Concepts/6-Chains.html).

In addition to the details listed, there are some advanced options including but not limited to the number of generated results, the number of attempts the agent makes, and the predefined memory collections.
